//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.3 Page 118
//Title: Nitration of chlorobenzene

//=======================================================
package Ex4_3

//=======================================================
model Ex4_3_a
/* Analysis of charge */

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 100 "Chlorobenzene charged" ;
parameter Real m2(unit = "kg") = 106.5 "Mass of nitric acid" ;
parameter Real m3(unit = "kg") = 108 "Mass of Sulphuric acid" ;
parameter Real mf2 = 0.655 "Mass fraction of nitrc acid" ;
parameter Real mf3 = 0.936 "Mass fraction of sulphuric acid" ;

//=======================================================
//Variable Section
Real M1(unit = "kg") "HNO3 in charge" ;
Real M2(unit = "kg") "H2SO4 in charge" ;
Real M3(unit = "kg") "Water in charge" ;
Real CB "Mass percent of Chlorobenzene in feed" ;
Real HNO3 "Mass percent of HNO3 in feed in feed" ;
Real H2SO4 "Mass percent of H2SO4" ;
Real H2O "Mass percent of H2O in feed" ;
Real m(unit = "kg") "Total mass of feed" ;

//=======================================================
//Equation Section
equation
M1 = m2*mf2 ;
M2 = m3*mf3 ;
M3 = m2*(1-mf2)+m3*(1-mf3) ;
m = m1+M1+M2+M3 ;
CB = m1/m*100 ;
HNO3 = M1/m*100 ;
H2SO4 = M2/m*100 ;
H2O = 100-(CB+HNO3+H2SO4) ;

end Ex4_3_a ;
//=======================================================

//=======================================================
model Ex4_3_b 
/*Percentage conversion of chlorobenzene */

//=======================================================
//Parameter Section
parameter Real per_unreacted = 2 "Percent of unreacted chlorobenzene in product" ;

//=======================================================
//Reference Section
extends Ex4_3_a ;

//=======================================================
//Variable Section
Real reacted(unit = "kg") "Reacted CB" ;
Real unreacted(unit = "kg") "Unreacted CB in product" ;
Real conversion "Percent conversion of CB" ;

//=======================================================
//Equation Section
equation
unreacted = m*per_unreacted/100 ;
reacted = m1-unreacted ;
conversion = reacted/m1*100 ;

end Ex4_3_b ;
//=======================================================

//=======================================================
model Ex4_3_c
/* Composition of product */

//=======================================================
//Parameter Section
parameter Real p1 = 66 "Percent of p-NCB in product" ;
parameter Real p2 = 34 "Percent of o-NCB in product" ;

//=======================================================
//Referance Section
extends Ex4_3_b ;

//=======================================================
//Variable section
Real M_HNO3(unit = "kg") "Total HNO3 consumed";
Real Un_HNO3(unit = "kg") "Unreacted HNO3" ;
Real NCB(unit = "kg") "Total NCB produced" ;
Real p_NCB(unit = "kg") "p-NCB in product" ;
Real o_NCB(unit = "kg") "o-NCB in product" ;
Real M_H2O(unit = "kg") "Water produced" ;
Real T_H2O(unit = "kg") "Total water in product" ;
Real per_CB "Percent CB in product" ;
Real per_p_NCB "Percent p-NCB in product" ;
Real per_o_NCB "Percent o-NCB in product" ;
Real per_HNO3 "Percent HNO3 in product" ;
Real per_H2SO4 "Percent H2SO4 in product" ;
Real per_H2O "Percent H2O in product"; 

//=======================================================
//Equation Section
equation
M_HNO3 = 63/112.5*reacted ;
Un_HNO3 = M1-M_HNO3 ;
NCB = 157.5/112.5*reacted ;
p_NCB = p1/100*NCB ;
o_NCB = p2/100*NCB ;
M_H2O = 18/112.5*reacted ;
T_H2O = M3+M_H2O ;
per_CB = per_unreacted ;
per_p_NCB = p_NCB/m*100 ;
per_o_NCB = o_NCB/m*100 ;
per_HNO3 = Un_HNO3/m*100 ;
per_H2SO4 = M2/m*100 ;
per_H2O = T_H2O/m*100 ;

end Ex4_3_c ;
//=======================================================

end Ex4_3;
//=======================================================
