//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.6 Page 122
//Title: Ammonia manufacture by fertiliser plant

//=======================================================
package Ex4_6

//=======================================================
model Ex4_6_a
/* Moles of water gas amnd producer gas */

//=======================================================
//Parameter Section
parameter Real m(unit = "kmol") = 100 "Moles of dry mixed gas" ;

//=======================================================
//Variable Section
Real x(unit = "kmol") "Moles of water gas" ;
Real y(unit = "kmol") "Moles of producer gas" ;
Real n1(unit = "kmol") "H2 formed by shift reaction" ;
Real n2(unit = "kmol") "H2 entering with water gas and producer gas" ;
Real n3(unit = "kmol") "Total H2 after shift reaction in mixed gas" ;
Real n4(unit = "kmol") "N2 in mixed gases" ;
Real n5(unit = "kmol") "CO present in mixed gas" ;

//=======================================================
//Equation Section
equation
x+y = m ;
n5 = 0.43*x+0.25*y ; 
n1 = 0.43*x+0.25*y ; //Each kmol of CO gives 1 kmol of CO2 and 1 kmol of H2 
n2 = 0.51*x+0.05*y ;
n3 = 0.43*x+0.25*y+0.51*x+0.05*y ;
n4 = 0.02*x+0.63*y ;
3*n4 = n3 ;         //In Ammonia synthesis, N2:H2 is 1:3

//Refer Table 4.3, page 122

end Ex4_6_a ;
//=======================================================

//=======================================================
model Ex4_6_b
/* Dry mixed gas analysis */

//=======================================================
//Reference Section
extends Ex4_6_a ;

//=======================================================
//Variable Section
Real n6(unit = "kmol") "CO2 in mixed gas" ;
Real n7(unit = "kmol") "Ar in mixed gas" ;
Real vol1 "Volume percent of N2" ;
Real vol2 "Volume percent of H2" ;
Real vol3 "Volume percent of CO" ;
Real vol4 "Volume percent of CO2" ;
Real vol5 "VOlume percent of Ar" ;

//=======================================================
//Equation Section
equation
n6 = 0.04*x+0.05*y ;
n7 = 0.02*y ;
vol1 = n4/m*100 ;
vol2 = n2/m*100 ;
vol3 = n5/m*100 ;
vol4 = n6/m*100 ;
vol5 = n7/m*100 ;

end Ex4_6_b;
//=======================================================

//=======================================================
model Ex4_6_c
/*Amount of steam required */

//=======================================================
//Variable Section
Real n(unit = "kmol") "Amount of steam required" ;
Real ms(unit = "kg") "Amount of steam required" ;

//=======================================================
//Reference Section
extends Ex4_6_a ;

//=======================================================
//Equation Section
equation
n = 0.43*x+0.25* y ; //Amount of steam required =  Amount of CO converted
ms = n*18 ;

end Ex4_6_c ;
//=======================================================

end Ex4_6;
//=======================================================