//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.9 Page 125
//Title: Vanaspati production

//=======================================================
package Ex4_9

//=======================================================
model Ex4_9_a 
/* Theoretical H2 requirement */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Basis of soya fatty acids" ;

//=======================================================
//Variable Section
Real Mavg1(unit = "kg/kmol") "Average molar mass of soya fatty acids" ;
Real Mavg2(unit = "kg/kmol") "Average molar mass of soybean oil" ;
Real m1 "Quantity of soybean oil in kg of soybean oil per 100 kg of soya fatty acid" ;
Real m2 "Theoretical H2 requirement for full hydrogenation in kmol of H2/100 kg soya fatty acid" ;
Real m3 "Theoretical H2 requirement for full hydrogenation in kmol of H2/100 kg soybean oil" ;
Real m4 "Theoretical H2 requirement for full hydrogenation in Nm^3 of H2/100 kg soybean oil" ;

//=======================================================
//Equation section
equation
Mavg1 = m/0.3597 ;
Mavg2 = Mavg1*3+92.09-3*18.02 ;
m1 = Mavg2*m/(Mavg1*3) ;
m2 = 0.0967+(0.1822*2)+(0.0241*3) ; //On the basis of reactions, pg 126
m3 = m2*m/m1 ;
m4 = m3*22.414 ;

//NOTE: Refer Table 4.5 and 4.6, pg 125 and 126 respectively
//3 mol of fatty acid + 1 mol of glycerol(M.wt = 92.09 kg/kmol) = 1 mol triglyceride + 3 mol H2O

end Ex4_9_a ;
//=======================================================

//=======================================================
model Ex4_9_b
/* Actual H2 requirement */

//=======================================================
//Reference Ection
extends Ex4_9_a ;

//=======================================================
//Variable Section
Real x(unit = "kg") "Mass of linoleic acid converted to oleic acid" ;
Real y(unit = "kg") "Mass of oleic acid converted o stearic acid" ;
Real m5(unit = "kg") "Oleic acid production due to conversion of linolenic acid" ;
Real m6(unit = "kg") "Oleic acid produced from linoleic acid" ;
Real m7(unit = "kg") "Stearic acid produced from oleic acid" ;
Real Stearic(unit = "kg") "Stearic acid after partial hydrogenation" ;
Real Oleic(unit = "kg") "Oleic acid after partial hydrogenation" ;
Real linoleic(unit = "kg") "Linoleic acid after partial hydrogenation" ;
Real Mavg3(unit = "kg/kmol") "Average molar mass of fatty acid in hardened fat" ;
Real Mavg4(unit = "kg/kmol") "Average molar mass of hardened fat" ;
Real m8 "Quantity of hardened fat in kg hardened fat/100 kg of soya fatty acid" ;
Real m9 "Quantity of hardened fat in kg hardened fat/100 kg of soybean oil" ;
Real Net_H "Net H2 requirement for partial hydrogenation in Nm3 of H2/Ton of soybean oil" ;
 
//=======================================================
//Equation section
equation
m5 = 282.6/278.43*6.7 ;
m6 = 282.46/280.45*x ;
m7 = 284.48/282.46*y ;
Stearic = 3.8+m7 ;
Oleic = 34.097+m6-y ;
linoleic = 51.1-x ;
-0.00105*x+1.00611*y = 10.8142 ;    //Stearic acid balance
1.00019*x+0.00019*y = 48.4975 ;     //Linoleic acid balance
Mavg3 = 100.52/0.3596 ;
Mavg4 = Mavg3 * 3+92.09-3*18.02 ;
m8 = Mavg4*100.52/(Mavg3*3) ;
m9 = 0.2864 ;
Net_H = (m2-m9)*100/m1*22.414*10 ;

//Note: Full conversion of linolenic acid to oleic acid

end Ex4_9_b ;
//======================================================= 

//=======================================================
model Ex4_9_c 
/* Iodive Value */

//=======================================================
//Parameter Section
parameter Real M(unit = "kg/kmol") = 253.81 "Molar mass of I2" ;

//=======================================================
//Reference Section
extends Ex4_9_b;

//=======================================================
//Variable Section
Real IV_soy "Iodine value for soybean oil in kg I2/100 kg of soybean oil" ;
Real IV_fat "Iodine value for hardened fat in kg I2/100 kg of fat" ;

//=======================================================
//Equation Section
equation
IV_soy = m3*M ;
IV_fat = 0.2726*M ;

end Ex4_9_c ;
//=======================================================

end Ex4_9;
//=======================================================