//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.1 Page 186
//Title: Energy balance

//=======================================================
model Ex5_1

//=======================================================
//Parameter Section
parameter Real qm(unit = "L/s") = 1 "Water flow rate" ;
parameter Real q1(unit = "kW") = 52 "Heat supplied to the system" ;
parameter Real q2(unit = "kW") = 21 "Heat lost to the surroundings" ;
parameter Real Z1(unit = "m") = -50 "Depth of well" ;
parameter Real Z2(unit = "m") = 10 "Elevation of stoage tank from ground" ;
parameter Real w(unit = "kW") = 1.5 "Pump work" ;
parameter Real g(unit = "m/S2") = 9.80665 "Acceleration due to gravity" ;
parameter Real gc(unit = "kg.m/(N.s2)") = 1 ;

//=======================================================
//Variable Section
Real Q(unit = "kW") "Net heat gained by water" ;
Real W(unit = "kW") "Net pump work done on the fluid" ;
Real delta_E(unit = "kW") "Change in internal energy" ;

//=======================================================
//Equation Section
equation
Q = q1-q2 ;
W = 0.55*w ;                  
qm*(Z1*g/gc/1000)+W+Q = delta_E+qm*(Z2*g/gc/1000) ;                    //Bernoulli's equation

//Note: P1 = P2
end Ex5_1;