//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.15 Page 238
//Title: Refrigeration system for MEG

//=======================================================
model Ex5_15

//=======================================================
//Parameter Section
parameter Real qv1(unit = "L/s") = 50 "Flow rate of MEG(brine)" ;
parameter Real rho(unit = "kg/L") = 1.08 "Density of MEG" ;
parameter Real Cp(unit = "kJ/(kmol K)") = 3.08 "Specific heat of aq. MEG" ;
parameter Real Th1(unit = "K") = 263.15 "Initial temperature of MEG" ;
parameter Real Th2(unit = "K") = 258.15 "Final temperature of MEG" ;

//=======================================================
//Variable Section
Real qm(unit = "kg/s") "Mass flow rate of MEG" ;
Real Q(unit = "kW") "Heat transfer in chiller" ;
Real lambda(unit = "kJ/kg") "Latent heat of vapourisation of R-134a at 249.15 K" ;
Real qm2(unit = "kg/s") "Evaporation rate of R-134a in chiller" ;
Real x(unit = "kg/s") "Flash vapours formed due to isoenthalpic expansion of R-134a" ;
Real T(unit = "kg/s") "Total flow of R-134a vapour" ;

//=======================================================
//Equation Section
equation
qm = qv1*rho ;
Q = qm*Cp*(Th1-Th2) ;
lambda = 384.19-168.7 ;
qm2 = Q/lambda ;
256.35*(qm2+x) = 168.7*qm2+x*384.19 ;
T = qm2+x ;

end Ex5_15;
//=======================================================