//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.22 Page 252
//Title: Adiabatic flashing

//=======================================================
model Ex5_22

//=======================================================
//Parameter Section
parameter Real m(unit = "kmol") = 1 "Basis for mixture" ;

//=======================================================
//Variable Section
Real L "Fraction of liquid" ;
Real H1(unit = "kJ/kmol") "Enthalpy of original saturated liquid mixture" ;
Real H2(unit = "kJ/kmol") "Enthalpy of saturated liquid fraction after flashing" ;
Real H3(unit = "kJ/kmol") "Enthalpy of vapour mixture in equilibrium with liquid" ;
Real H4(unit = "kJ/kmol") "Enthalpy of vapour-liquid mixture after flashing" ;

//=======================================================
//Equation Section
equation
//Using equation 5.48
L = 0.451/1.355 ;
H1 = 23549 ;
H2 = 16325 ;
H3 = 28332 ;
H4 = 0.4*H2+0.6*H3 ;

end Ex5_22;
//=======================================================