//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.24 Page 256
//Title: Refrigeration calculations

//=======================================================
package Ex5_24

//=======================================================
model Ex5_24_a
/* Refrigeration requirement assuming ideal gas */

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 313.15 "Feed gas temperature" ;
parameter Real T2(unit = "K") = 304.15 "Refrigerated gas temperature" ;

//=======================================================
//Variable Section
Real Q(unit = "kJ/hr") "Refrigeration requirement" ;

//=======================================================
//Equation Section
equation
Q = 11831.6*(T1-T2)+24997.4*10^(-3)*(T1^2-T2^2)/2-5979.8*10^(-6)*(T1^3-T2^3)/3-31.7*10^(-9)*(T1^4-T2^4)/4 ;

end Ex5_24_a ;
//=======================================================

//=======================================================
model Ex5_24_b
/* Refrigeration requirement based on table 5.19 */

//=======================================================
//Variable Section
Real Q(unit = "kJ/hr") "Enthalpy of gas" ;

//=======================================================
//Equation Section
equation
Q = 535.4*12086-(344.36*8743.2+168.97*18036+22.07*15892) ;

//Note: Q = Enthalpy of feed - Enthalpy of product

end Ex5_24_b ;
//=======================================================

end Ex5_24;
//=======================================================
