//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.35 Page 273
//Title: Heat transfer in intercooler 

//=======================================================
package Ex5_35

//=======================================================
model Ex5_35_a
/* Heat transfer using heat capacity data */

//=======================================================
//Parameter Section
parameter Real n(unit = "kmol/hr") = 125.435 "Molar flow rate of inlet gas" ;
parameter Real T(unit = "K") = 800 "Temperature of ingoing gas" ;
parameter Real T1(unit = "K") = 875 "Temperature of outgoing gas" ;
parameter Real Hr0(unit = "kJ/kmol") = -98910 "Standard heat of reaction of SO2 formation" ;

//=======================================================
//Variable section
Real Q1(unit = "kW") "Enthalpy of ingoing gas" ;
Real Q2(unit = "kW") "Enthalpy of outgoing gas" ;
Real Q3(unit = "kW") "Total heat of reaction at 293=8.15";
Real net_Q(unit = "kW") "Net enthalpy change" ;
 
//=======================================================
//Equation Section
equation
Q1 = (3614.577*(T-298.15)+305.561*10^(-3)*(T^2-298.15^2)/2+836.881*10^(-6)*(T^3-298.15^3)/3-393.707*10^(-9)*(T^4-298.15^4)/4)/3600 ;
Q2 = (3480.737*(T1-298.15)+754.347*10^(-3)*(T1^2-298.15^2)/2+442.159*10^(-6)*(T1^3-298.15^3)/3- 278.735*10^(-9)*(T1^4-298.15^4)/4)/3600 ;
Q3 = (8.8511-0.351)*(Hr0/3600) ;
net_Q = Q2+Q3-Q1 ;

//Note: Ref. Ex5_33
end Ex5_35_a ;
//=======================================================

//=======================================================
model Ex5_35_b
/* Heat transfer using data from Table 5.22 */

//=======================================================
//Variable Section
Real Q(unit = "kW") "Net enthalpy change" ;

//=======================================================
//Equation Section
equation
Q = -286.34-(-148.51) ;

//Ref. Table 5.28, pg 275

end Ex5_35_b ;
//=======================================================
 
end Ex5_35;
//=======================================================