//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.5 Page 206
//Title: Aqueous caustic soda heating

//=======================================================
model Ex5_5

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 280.15 "Temperature before heating" ;
parameter Real T2(unit = "K") = 360.15 "Temperature after heating" ;
parameter Real x = 20 "Mass percent of NaOH in solution" ;
parameter Real m(unit = "kg") = 1 "Mass of NaOH solution" ;
parameter Real C11(unit = "kJ/(kg K)") = 3.56 "Heat capacity of 20% NaOH at T1" ;
parameter Real C12(unit = "kJ/(kg K)") = 3.71 "Heat capacity of 20% NaOH at 21" ;

//=======================================================
//Variable Section 
Real C1m(unit = "kJ/(kg K)") "Mean heat capacity of 20% NaOH" ;
Real H(unit = "kJ") "Heat required to raise the temperature" ;

//=======================================================
//Equation Section
equation 
C1m = (C11+C12)/2 ;
H = m*C1m*(T2-T1) ;

//Note: Ref. Fig. 5.4

end Ex5_5;
//=======================================================