//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.50 Page 302
//Title: Dilution of H2SO4

//=======================================================
package Ex5_50

//=======================================================
model Ex5_50_a
/** Resultant temp. of solution */


//=======================================================
//Variable Section
Real T(unit = "K") "Temperature of final solution" ;

//=======================================================
//Equation section
equation
T = 379.5 ;

//Note: Ref. Fig 5.18

end Ex5_50_a ;
//=======================================================

//=======================================================
model Ex5_50_b
/* Heat removal */

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 379.5 "Temperature of final solution" ;
parameter Real H1(unit = "kJ/kg") = -106.5 "Entahlpy of 77% H2SO4 at 379.5 K" ;
parameter Real H2(unit = "kJ/kg") = -274 "Entahlpy of 77% H2SO4 at 298.15 K" ;

//=======================================================
//Variable section
Real delta_H(unit = "kJ/kg") "Change in enthalpy of 77% soln." ;

//=======================================================
//Equation Section
equation
delta_H = H2-H1 ;

end Ex5_50_b ;
//=======================================================

//=======================================================
model Ex5_50_c
/* Heat removed from heat capacity data */

//=======================================================
//Parameter Section
Real Cpm(unit = "kJ/(kg K)") = 2.05 "Mean heat capacity" ;


//=======================================================
//Variable Section
Real delta_H(unit = "kJ/kg") "Change in enthalpy of 77% soln." ;

//=======================================================
//Equation Section
equation
delta_H = Cpm*(379.5-298.15) ;

end Ex5_50_c ;
//=======================================================

//=======================================================
model Ex5_50_d
/* Quantity of acid to be mixed */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of acid" ;

//=======================================================
//Variable Section
Real x(unit = "kg") "Mass of 15% acid to be mixed" ;

//=======================================================
//Equation Section
equation
//Acid balance
0.93*m + x*0.15 = (100+x)*0.77 ;

end Ex5_50_d ;
//=======================================================

//=======================================================
model Ex5_50_e
/* Using coordinate geometry principle */

//=======================================================
//Variable Section
Real Quantity(unit = "kg") "Quantity of 15% acid required to be mixed" ;

//=======================================================
//Equation section
equation
Quantity = (2.5/9.9)*100 ;

//Note: 93% acid quantity/15% acid quantity = CB/CA = 9.9 units/2.5 units
//Ref. Fig. 5.18
end Ex5_50_e ;
//=======================================================

end Ex5_50;
//=======================================================
