//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.51 Page 304
//Title: Using data, heat of formation of H2SO4

//=======================================================
model Ex5_51

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 100 "Mass of 93% acid" ;
parameter Real m2(unit = "kg") = 25.8 "Mass of 15% acid" ;

//=======================================================
//Variable Section
Real Hf1(unit = "kJ/mol") "Heat of formation of 93% H2SO4" ;
Real Hf2(unit = "kJ/mol") "Heat of formation of 100% H2SO4" ;
Real Hsol1(unit = "kJ/mol") "Heat of solution" ;
Real Hf3(unit = "kJ/mol") "Heat of formation of 15% H2SO4" ;
Real Hsol2(unit = "kJ/mol") "Heat of solution" ;
Real Hf4(unit = "kJ/mol") "Heat of formation of 77% H2SO4" ;
Real Hsol3(unit = "kJ/mol") "Heat of solution" ;
Real Hsol(unit = "kJ/mol") "Heat of solution of mixture at 298.15 K" ;
Real Q1(unit = "kJ") "Heat evolved by cooling 93% H2SO4 soln" ;
Real Q2(unit = "kJ") "Heat consumed by 15% H2SO4 soln" ;
Real Q3(unit = "kJ") "Net heat evolved" ;
Real T(unit = "K") "Temperature of 77% solution" ;

//=======================================================
//Equation Section
equation  
Hf1 = -830 ;
Hf2 = -814 ;
Hsol1 = Hf1-Hf2 ;
Hf3 = -886.2 ;
Hsol2 = Hf3-Hf2 ;
Hf4 = -851 ;
Hsol3 = Hf4-Hf2 ;
Hsol = 0.9876*1000*Hsol3-(0.9482*1000*Hsol1+0.0394*1000*Hsol2) ;
Q1 = m1*(30-25)*1.6 ;
Q2 = m2*(25-0)*3.7 ;
Q3 = -Hsol+Q1-Q2 ;
T = 298.15+Q3/(125.8*2.05) ;

//Ref. Fig. 5.19
//Ref. Fig 5.5 for average heat capacities

end Ex5_51;
//=======================================================