//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.53 Page 308
//Title: Nitration of benzene using mixed acid

//=======================================================
model Ex5_53

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg/hr") = 400 "C6H6 feed to freactor" ;
parameter Real m2(unit = "kg/hr") = 1135 "Mixed acid feed to freactor" ;
parameter Real conv = 0.993 "Conversion of C6H6" ;

//=======================================================
//Variable section
Real m3(unit = "kg/hr") "HNO3 fed to reactor" ;
Real m4(unit = "kg/hr") "HNO3 required for 100% conversion of C6H6" ;
Real m5(unit = "kg/hr") "Excess HNO3" ;
Real E "% excess HNO3" ;
Real m6(unit = "kg/hr") "Benzene converted" ;
Real m7(unit = "kg/hr") "HNO3 consumed" ;
Real m8(unit = "kg/hr") "Water formed" ;
Real M1 "Total acid content in mixed acid" ;
Real M2 "HNO3 content of anhydrous mixed acid" ;
Real H1(unit = "kJ/kg") "Enthalpy of mixed at 298.15 K" ;
Real M3 "Total acid content in spent acid " ;
Real M4 "HNO3 content of anhydrous spent acid" ;
Real H2(unit = "kJ/kg") "Enthalpy of spent acid at 298.15 K" ;
Real H3(unit = "kJ/kg") "Enthalpy of pure HNO3 at 298.15 K" ;
Real Hr(unit = "kJ/kmol") "Std. heat of reaction" ;
Real n(unit = "kmol") "C6H6 reacted" ;
Real Q(unit = "kJ/hr") "Total heat changes" ;

//=======================================================
//Equation Section
equation
m3 = m2*0.315 ;
m4 = (63/78)*m1 ;
m5 = m3-m4 ;
E = m5/m4*100 ;
m6 = m1*conv ;
m7 = (63/78)*m6 ;
m8 = (18/78)*m6 ;
//Feed mixed acid
M1 = 56+31.5 ;
M2 = 31.5/M1*100 ;
H1 = -186.5+1.88*(298.15-273.15) ;      //H = -186.5 kJ/kg C11 = 1.88 at 273.15 K
//Spent acid
M3 = 70.1+4.06 ;
M4 = 4.06/M3*100 ;
H2 = -288.9+1.96*(298.15-273.15) ;      //H = -288.9 kJ/kg C12 = 1.96 at 273.15 K
//Pure HNO3
H3 = 1.98*(298.15-273.15) ;             //C13 = 1.98 at 273.15
Hr = -285.83+12.5-(-174.1+49.08) ;
n = m6/78.1118 ;
Q = 903.84*H2+m7*H3-m2*H1+n*Hr*1000 ;

end Ex5_53;
//=======================================================
