//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.55 Page 311
//Title: Ex5_32 using Table 5.60

//=======================================================
model Ex5_55

//=======================================================
//Parameter Section
parameter Real Hf1(unit = "kJ/kmol") = -80.14 "Heat of formation of 2% NH3" ;
parameter Real Hf2(unit = "kJ/kmol") = -46.11 "Heat of formation of gaseous NH3" ;

//=======================================================
//Variable Section
Real Hsol(unit = "kJ/mol") "Heat of solution" ;
Real Q(unit = "kJ/kg") "Heat generated for making 2% NH3 per 100 kg of solution" ;

//=======================================================
//Equation Section
equation
Hsol = Hf1-Hf2 ;
Q = -Hsol*1000*2/17.0305 ;

end Ex5_55;
//=======================================================