//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.9 Page 220
//Title: Vapour pressure using Antoine constant 

//=======================================================
package Ex5_9

//=======================================================
model Ex5_9_a
/* V.P of n-hexane */

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 305.15 "Temperature" ;

//=======================================================
//Variable Section
Real Pv(unit = "bar") "Vapour pressure" ;

//=======================================================
//Equation Section 
equation
log10(Pv) = 4.00266-(1171.53/(T-48.784)) ;

//Note: Ref. Table 5.4

end Ex5_9_a ;
//=======================================================

//=======================================================
model Ex5_9_b
/* V.P of water */

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 395.15 "Temperature" ;

//=======================================================
//Variable Section
Real Pv(unit = "bar") "Vapour pressure of water" ;

//=======================================================
//Equation Section 
equation
log10(Pv) = 3.55959-(643.748/(T-198.043)) ;

//Note: Ref. Table 5.4

end Ex5_9_b ;
//=======================================================
end Ex5_9;
