//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.11 Page 370
//Title: Recovery of p-DCB

//======================================================
package Ex6_11

//======================================================
model Ex6_11_a
/* Recovery of p_DCB */

//======================================================
//Parameter Section
parameter Real basis(unit = "kg") = 100 "Basis of feed" ; 
parameter Real m1(unit = "kg") = 70 "p_DCB in feed" ; 

//======================================================
//Variable Section
Real rec "Solids of p-DCB separated" ;
Real recovery "Percent recovery of p_DCB" ;

//======================================================
//Equation Section
equation
//Refer Fig. 6.12 pg 370
rec = 4.91/(4.91+5.76)*100 ;                    //At 290 K
recovery = rec/m1*100 ;

end Ex6_11_a ;
//======================================================

//======================================================
model Ex6_11_b
/* Recovery of crystals on further cooling */

//======================================================
//Reference Section
extends Ex6_11_a ;

//======================================================
//Variable Section
Real rec1 "Solids of p-DCB separated at 2555 K" ;
Real recovery1 "Percent recovery of p_DCB" ;
Real add_rec "Additional recovery of p_DCB" ;

//======================================================
//Equation Section
equation
rec1 = 10.22*100/(5.76+10.22) ;
recovery1 = rec1*100/m1 ;
add_rec = recovery1-recovery ;

end Ex6_11_b ;
//======================================================

end Ex6_11;
//======================================================

