//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.12 Page 371
//Title: Extractive crystallisation

//======================================================
package Ex6_12

//======================================================
model Ex6_12_a
/*Flow rate of products and theri purity */

//======================================================
//Parameter Section
parameter Real F(unit = "kg/hr") = 5000 "Feed of solvent free mixture" ;
parameter Real m1(unit = "kg/hr") = 4000 "p-NCB in feed" ;           //80% of feed
parameter Real m2(unit = "kg/hr") = 1000 "o-NCB in feed" ;           //20% of feed
parameter Real x1 = 0.331 "Mole fraction of p-NCB in eutectic mixture" ;

//======================================================
//Variable Section
Real p_NCB(unit = "kmol/hr") "Moles of p-NCB in feed" ;
Real o_NCB(unit = "kmol/hr") "Moles of o-NCB in feed" ;
Real mot_liq(unit = "kmol/hr") "Total mother liquor entering ectractive crystallisation unit" ;
Real p_NCB1(unit = "kmol/hr") "Moles of p-NCB in mother liquor" ;
Real R "Reflux ratio" ;
Real T(unit = "kg/hr",start = 1) "Flow rate of top product from extraction unit" ;
Real D(unit = "kg/hr") "Flow rate of bottom product from both extraction unit" ;
Real x(start = 1) "Mass fraction of p-NCB in T" ;
Real G(unit = "kg/hr") "Flow rate to recovety unit" ;
Real H(unit = "kg/hr") "Flow rate of bottom product from recovery unit" ;
Real P1 "Purity of o-NCB in top product" ;
Real P2 "Purity of p-NCB bottom product" ;

//======================================================
//Equation Section
equation
p_NCB = m1/157.5 ;
o_NCB = m2/157.5 ;
mot_liq = o_NCB/(1-x1) ;
p_NCB1 = mot_liq-o_NCB ;
//Optimising solid freflux
//dCT/dR = 1-2/R^3
R^3 = 2 ;
//Ref. Fig. 6.14, pg 372
//Overall material balance
//Material balance of p-NCB
0.98*D+x*T = m1 ;
//Material balance of o-NCB
0.02*D+(1-0.05-x)*T = m2 ;
//Material balance across solvent recovery unit
//Material balance of p-NCB
2.26*T*x = 0.198*G ;
0.198*G = x*H ;
//Material balance of o-NCB
2.26*T*(0.95-x) = 0.531*G ;

P1 = (1-x-0.05)*T/T*100 ;
P2 = 0.98*D/D*100 ;

end Ex6_12_a ;
//======================================================

//======================================================
model Ex6_12_b
/* Make up solvent */

//======================================================
//Variable Section
Real M(unit = "kg/hr") "Make up Solvent" ;

//======================================================
//Equation Section
equation
//Refer Table 6.11
//Loss of solvent = Make up solvent
M = 66.9 ;

end Ex6_12_b ;
//======================================================

end Ex6_12;
//======================================================S
