//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.23 Page 401
//Title: Quadruple effect forward feed evaporater

//======================================================
model Ex6_23

//======================================================
//Parameter Section
parameter Real Wf(unit = "kg/hr") = 1060 "Weak liquor flow rate" ;
parameter Real Tf(unit = "K") = 303 "Feed temperature" ;
parameter Real T1(unit = "K") = 422.6 "Temperature of steam from I effect" ;
parameter Real T2(unit = "K") = 410.5 "Temperature of steam from II effect" ;
parameter Real T3(unit = "K") = 390.2 "Temperature of steam from III effect" ;
parameter Real T4(unit = "K") = 354.7 "Temperature of steam from IV effect" ;

//======================================================
//Variable Section
Real ms(unit = "kg/hr") "Solids in weak liquor" ;
Real Ws(unit = "kg/hr") "Feed flow of steam" ;
Real W1(unit = "kg/hr") "Feed flow of liquor leaving I effect" ;
Real W2(unit = "kg/hr") "Feed flow of liquor leaving II effect" ;
Real W3(unit = "kg/hr") "Feed flow of liquor leaving III effect" ;
Real W4(unit = "kg/hr") "Feed flow of liquor leaving IV effect" ;
Real st_eco "Steam economy" ;
Real sp_st "Specific steam consumption" ;

//======================================================
//Equation Section
equation
ms = Wf*0.04 ;
W4 = ms/0.25 ;
//Enthalpy balance of first effect
Ws*2046.3 = Wf*4.04*(T1-Tf)+(Wf-W1)*2114.4 ;
//Enthalpy balance of II effect
(Wf-W1)*2114.4 = W1*3.977*(T2-T1)+(W1-W2)*2151.4 ;
//Enthalpy balance of III effect
(W1-W2)*2151.4 = W2*3.936*(T3-T2)+(W2-W3)*2210.2 ;
//Enthalpy balance of IV effect
(W2-W3)*2210.2 = W3*3.894*(T4-T3)+(W3-W4)*2304.6 ;
st_eco = (Wf-ms/0.25)/Ws ;
sp_st = 1/st_eco ;

end Ex6_23;
//======================================================
