//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.5 Page 356
//Title: Heat effect of scrubbing

//======================================================
package Ex6_5
model Ex6_5_a 
/* Composition of liquor leaving column */

//======================================================
//Parameter Section
parameter Real Q(unit = "m^3/hr") = 50000 "Flow rate of gas mixture" ;
parameter Real x = 0.95 "Mole fraction of N2 in outgoing gas" ;
parameter Real L(unit = "L/min") = 500 "Flow of liquor" ;
parameter Real rho_sol(unit = "kg/L")  = 1.25 "Density of solution" ;

//======================================================
//Variable Section
Real n(unit = "kmol/hr") "Molar flow rate of incoming gas" ;
Real n1(unit = "kmol/hr") "NO2 content of gas" ;
Real n2(unit = "kmol/hr") "N2O4 content of gas" ;
Real n3(unit = "kmol/hr") "N2 content of gas" ;
Real n4(unit = "kmol/hr") "Molar flow rate of incoming gas mixture" ;
Real n5(unit = "kmol/hr") "NO2 removed from gas mmixture" ;
Real n6(unit = "kmol/hr") "N2O4 removed from gas mixture" ;
Real n7(unit = "kg/hr") "NaOH consumed in reaction (ii)" ;
Real n8(unit = "kg/hr") "NaNO2 produced in reaction (ii)" ;
Real n9(unit = "kg/hr") "NaNO3 produced in reaction (ii)" ;
Real n10(unit = "kg/hr") "H2O produced in reaction (ii)" ;
Real n11(unit = "kmol/hr") "NO2 consumed in reaction (iii)" ;
Real n12(unit = "kg/hr") "NaOH consumed in reaction (iii)" ;
Real n13(unit = "kg/hr") "NaNO3 produced in reaction (iii)" ;
Real n14(unit = "kg/hr") "H2O produced in reaction (iii)" ;
Real n15(unit = "kmol/hr") "NO2 absorbed in reaction (i)" ;
Real n16(unit = "kg/hr") "NaOH consumed in reaction (i)" ;
Real n17(unit = "kg/hr") "NaNO2 produced in reaction (i)" ;
Real n18(unit = "kg/hr") "NaNO3 produced in reaction (i)" ;
Real n19(unit = "kg/hr") "H2O produced in reaction (i)" ;
Real Tot_NaNO2(unit = "kg/hr") "Total NaNO2 produced" ;
Real Tot_NaNO3(unit = "kg/hr") "Total NaNO3 produced" ;
Real Tot_H2O(unit = "kg/hr") "Total H2O produced" ;
Real Tot_NaOH(unit = "kg/hr") "Total NaOH consumed" ;
Real l(unit = "kg/hr") "Mass flow rate of liquor" ;
Real NaOH_in(unit = "kg/hr") "NaOH in feed" ;
Real NaOH_out(unit = "kg/hr") "NaOH in outgoing liquid" ;
Real H2O_gout(unit = "kg/hr") "Moisture in exit gas stream" ;
Real H2O_sout(unit = "kg/hr") "Water in outgoing solution" ;

//======================================================
//Equation Section
equation
n = Q/24.57 ;                        //Specific volume of gas at 295.5 K and 101.325 kPa
n1 = n*0.0546 ;
n2 = n*0.0214 ;
n3 = n-(n1+n2) ;
n4 = n3/x ;
n5 = n1-77.78 ;
n6 = n2-16.23 ;
//Refer Table 6.3, page 357
//N2O4 absorbtion rnx (ii)
n7 = 2*40*n6 ;
n8  = 69*n6 ;
n9 = 85*n6 ;
n10 = 18*n6 ;
//NO production rnx (iii)
n11 = 3*4.95 ;
n12 = 2*4.95*40 ;
n13 = 2*4.95*85 ;
n14 = 4.95*18 ;
n15 = n5-n11 ;
//NO2 absorbtion rnx (i)
n16 = n15*40 ;
n17 = 69*n15/2 ;
n18 = 85*n15/2 ;
n19 = 18*n15/2 ;
Tot_NaNO2 = n8+n17 ;
Tot_NaNO3 = n9+n13+n18 ;
Tot_H2O = n10+n14+n19 ;
Tot_NaOH = n7+n12+n16 ;
//Material balance
l = L*rho_sol*60 ;
NaOH_in = l*0.236 ;
NaOH_out = NaOH_in-Tot_NaOH ;
H2O_gout = n4*0.045*18 ;
H2O_sout = l-NaOH_in+Tot_H2O-H2O_gout;

end Ex6_5_a ;
//======================================================

//======================================================
model Ex6_5_b
/*Heat effect of scrubbing */

//======================================================
//Parameter Section
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;
parameter Real T1(unit = "K") = 295.65  "Gas inlet temperature" ;
parameter Real T2(unit = "K") = 302.55  "Gas outlet temperature" ;

//======================================================
//Variable Section
Real Q1(unit = "kW") "Enthalpy of incoming gas" ;
Real Q2(unit = "kW") "Enthalpy of outgoing gas" ;
Real Hr1(unit = "kJ/mol") "Heat of reaction for reaction (i)" ;
Real Hr2(unit = "kJ/mol") "Heat of reaction for reaction (ii)" ;
Real Hr3(unit = "kJ/mol") "Heat of reaction for reaction (iii)" ;
Real Hd(unit = "kJ/mol") "Heat of dilution of NaOH" ;
Real Q3(unit = "kW") "total heat due to reaction and dilution" ;
Real Q4(unit = "kW") "Heat effect of scrubbing" ;

//======================================================
//Equation Section
equation
//Refer Table 6.6 pg 358
Q1 = (59865.7*(T1-T0)+4545.8*10^(-3)*(T1^2-T0^2)/2+15266.3*10^(-6)*(T1^3-T0^3)/3-7051.1*10^(-9)*(T1^4-T0^4)/4)/3600 ;
//Refer Table 6.7 pg 359
Q2 = (61039.6*(T2-T0)+2423.9*10^(-3)*(T2^2-T0^2)/2+21327.5*10^(-6)*(T2^3-T0^3)/3-8679.2*10^(-9)*(T2^4-T0^4)/4)/3600 ;
//Heat of reactions
 //Reaction (i)
 Hr1 = (-346.303-450.1-285.83-(2*(-468.257)+2*(33.18)))/2 ;
 //Reaction (ii)
 Hr2 = -346.303-450.1-285.83-(2*(-468.257)+9.16) ;
 //Reaction (iii)
 Hr3 = (2*(-450.1)-285.83+90.25-(2*(-468.257)+3*(33.18)))/3 ;
//Heat of dilution of 138.23 kmol/hr of NaOH
 Hd = -469.837-(-468.257) ;
Q3 = (-106.04*1000*18.48-154.879*1000*27.32-86.269*1000*14.85-1.58*138.23*1000)/3600 ;
Q4 = -Q1+Q2+Q3 ;

//Note: Hr1 is divived by 2 to find Hr1 per mole of NO2 Acc. to reaction (i)
//Note: Hr3 is divived by 3 to find Hr3 per mole of NO2 Acc. to reaction (iii)

end Ex6_5_b ;
//======================================================

end Ex6_5;
//======================================================
