//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.7 Page 361
//Title: Leaching of oil from Halibut liver

//======================================================
model Ex6_7

//======================================================
//Parameter Section
parameter Real F(unit = "kg") = 1000 "Mas of halibut liver" ;

//======================================================
//Variable Section
Real m1(unit = "kg/hr") "Oil in charge" ;
Real m2(unit = "kg/hr") "Solids in charge" ;
Real U(unit = "kg/hr") "Underflow rate" ;
Real m3(unit = "kg/hr") "Oil in underflow" ;
Real m4(unit = "kg/hr") "Ether content of underflow" ;
Real recovery(unit = "kg/hr") "Recovery of oil in overflow" ;
Real per_rec "Percentage recovery of oil" ;
Real O(unit = "kg/hr") "Overflow rate" ;
Real m5(unit = "kg/hr") "Ether content of overflow" ;
Real m6(unit = "kg/hr") "Total ether fed" ;

//======================================================
//Equation Section
equation
m1 = F*0.257 ;
m2 = F-m1 ;
U = 0.23*m2 ;
m3 = U*0.128 ;
m4 = U-m3 ;
recovery = m1-m3 ;
per_rec = recovery/m1*100 ;
O = recovery/0.7 ;
m5 = O-recovery ;
m6 = m4+m5 ;

end Ex6_7;
//======================================================