//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.2 Page 436
//Title: NCV of crude

//======================================================
model Ex7_2

//======================================================
//Parameter Section
parameter Real m(unit = "kg") = 1 "Basis for mass of crude oil" ;
parameter Real H2(unit = "kg") = 0.125 "H2 burnt" ;
parameter Real lambda(unit = "kJ/kg") = 2442.5 "Latent heat of water at 298.15 K" ;
parameter Real GCV(unit = "kJ/kg") = 45071 "GCV of crude at 298.15 K" ;

//======================================================
//Variable Section
Real H2O(unit = "kg") "H2O formed" ;
Real Q(unit = "kJ") "Latent heat of water vapour" ;
Real NCV(unit = "kJ/kg") "NCV of crude at 298.15 K" ;

//======================================================
//Equation Section
equation
H2O = H2/2*18 ;
Q = H2O*lambda ;
NCV = GCV-Q ;

end Ex7_2;
//======================================================