//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.4 Page 444
//Title: NCV and GCV of natural gas

//======================================================
model Ex7_4

//======================================================
//Parameter Section
parameter Real n(unit = "mol") = 1 "Basis of natural gas" ;
parameter Real M(unit = "kg/kmol") = 18.132 "Average molar mass of NG" ;

//======================================================
//Variable Section
Real H2O(unit = "g") "Total water formed" ;
Real Q(unit = "kJ/mol") "Heat lost due to vapourisation" ;
Real NCV(unit = "kJ/mol") "NCV of NG" ;
Real GCV(unit = "kJ/kg") "GCV of NG" ;
Real NCV1(unit = "kJ/kg") "NCV of NG" ;
Real GCV2(unit = "kJ/m^3") "GCV of NG" ;
Real NCV2(unit = "kJ/m^3") "NCV of NG" ;

//======================================================
//Equation Section
equation
H2O = (2*0.894+3*0.05+4*0.019+5*(0.004+0.006))*18 ;
Q = H2O*2442.5/1000 ;
//Using Table 7.7
NCV = 945.16-Q ;
GCV = 945.16*1000/M ;
NCV1 = NCV*1000/M ;
GCV2 = 945.16*1000/24.465 ;
NCV2 = NCV*1000/24.465 ;
//Specific volume at 101.3 kPa and 298.15 K is 24.465 m^3/kmol, table 7.8

end Ex7_4;
//======================================================