//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.8 Page 459
//Title: Sugar factory boiler

//======================================================
package Ex7_8

//======================================================
model Ex7_8_a
/* Theoretical air requirement */

//======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of bagasse fired as basis" ;

//======================================================
//Variable Section
Real theo_O2(unit = "kg") "Theoretical O2 requirement" ;
Real theo_N2(unit = "kg") "Theoretical N2 entering" ;
Real theo_air "Theoretical air requirement per unit mass of fuel" ;

//======================================================
//Equation Section
equation
theo_O2 = 2.02*32 ;
theo_N2 = (79/21)*2.02*28 ;
theo_air = (theo_O2+theo_N2)/100 ;

end Ex7_8_a ;
//======================================================

//======================================================
model Ex7_8_b
/* Actual air supply */

//======================================================
//Parameter Section
parameter Real CO2(unit = "kmol") =  1.95 "CO2 produced" ;

//======================================================
//Variable Section
Real m(unit = "kmol") "Total dry flue gas" ;
Real x(unit = "kmol") "Excess O2 in flue gas" ;
Real air_exc(unit = "kmol") "Excess O2+N2 from air" ;
Real O2_ent(unit = "kmol") "O2 entering furnace" ;
Real N2(unit = "kmol") "N2 entering through air" ;
Real excess "Percent excess air" ;

//======================================================
//Equation Section
equation
m = CO2/0.1565 ;
air_exc = m-CO2 ;
O2_ent = 2.02+x ;
N2 = 79/21*(2.02+x) ;
O2_ent+N2 = m ;
excess = x/2.02*100 ;

end Ex7_8_b ;
//======================================================

//======================================================
model Ex7_8_c
/* Dew point */

//======================================================
//Variable Section
Real Pw(unit = "kPa") "Partial pressure of water vapour" ;
Real T(unit = "K") "Dew point of flue gas" ;

//======================================================
//Equation Section
equation
Pw = (4.551/17.001)*100 ;
//Ref. Table 6.13
T = 339.85 ;

end Ex7_8_c ;
//======================================================

//======================================================
model Ex7_8_d
/* Thermal efficiency */

//======================================================
//Parameter Section
//From Appx. IV
parameter Real hfw(unit = "kJ/kg") = 292.97 "Enthalpy of feed water at 343.15 ";
parameter Real Hss(unit = "kJ/kg") = 3180.15 "Enthalpy of superheated steam at 21.5 bar and 643.15 K" ;

//======================================================
//Variable Section
Real Q(unit = "kJ/kg") "Net heat gained by water" ;
Real H6(unit = "kJ") "Total heat gained by water" ;
Real H1(unit = "kJ") "Total heat supplied by fuel" ;
Real GCV "Overall efficiency" ;

//======================================================
//Equation Section
equation
Q = Hss-hfw ;
H6 = 2.6*Q*100 ;
H1 = 100*10300 ;
GCV = H6/H1*100 ;

end Ex7_8_d ;
//======================================================

//======================================================
model Ex7_8_e
/* Heat balance of boiler */

//======================================================
//Parameter Section

//======================================================
//Variable Section
Real H7(unit = "kJ") "Heat lost in flue gas" ;
Real H9(unit = "kJ") "Heat lost due to evaporation of moisture" ;
Real H8(unit = "kJ") "Heat lost due to evaporation of moisture produced by H2 burnt" ;
Real H3(unit = "kJ") "Heat input by air" ;

//======================================================
//Equation Section
equation
H7 = (464.16-81.92)*1.4*(433.15-298.15) ;
H9 = 52*2343.6 ;
H8 = 1.4*18*2343.6 ;
H3 = (9.89*28+2.63*32)*1.03*(308.15-298.15) ;

end Ex7_8_e ;
//======================================================

//======================================================
model Ex7_8_f
/* Adiabatic flame temperature */

//======================================================
//Parameter Section
parameter Real T0 (unit = "K") = 298.15 "Refrence temperature" ;
parameter Real T1 (unit = "K") = 1500 "Temperature of flue gas" ;

//======================================================
//Variable Section
Real NCV(unit = "kJ/kg") "NCV of fuel at 298.15 K" ;
Real H1(unit = "kJ") "Heat input based on NCV" ;
Real T(unit = "K",start = 0)  "Adiabatic flame temperature" ;
Real H2(unit = "kJ") "Enthalpy of flue gas at 1500 K" ;
Real H(unit = "kJ") "Enthalpy of flue gas" ;
Real T2(unit = "K",start = 1500) "Adiabatic flame temperature" ;

//======================================================
//Equation Section
equation
NCV = 10300-((52+1.4*18)/100)*2442.5 ;
H1 = NCV*100 ;
H2 = 504.626*(T1-T0)+64.149*10^(-3)*(T1^2-T0^2)/2+124.744*10^(-6)*(T1^3-T0^3)/3-54.821*10^(-9)*(T1^4-T0^4)/4 ;
H = H1-H2 ;
H = 505.988*(T-T1)+187.03*10^(-3)*(T^2-T1^2)/2-47.76410*10^(-6)*(T^3-T1^3)/3+4.526*10^(-9)*(T^4-T1^4)/4 ;
H = 505.988*(T2-T1)+187.03*10^(-3)*(T2^2-T1^2)/2-47.76410*10^(-6)*(T2^3-T1^3)/3+4.526*10^(-9)*(T2^4-T1^4)/4 ;

end Ex7_8_f ;
//======================================================

end Ex7_8;
//======================================================
