//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-1: Dimensions and Units
//Example: 1.2 Page 12
//Title: Steam velocity in pipeline
//============================================
model Ex1_2

//============================================
//Parameter Section
parameter Real m(unit = "kg/hr") = 2000 "Mass flow rate of steam" ;
parameter Real d(unit = "inch NB 40 Sc") = 3 "Diameter of pipe" ;
parameter Real p(unit = "kPa") = 440 "Absolute Pressure of steam" ;
parameter Real T(unit = "K") = 453 "Temperature of steam" ;

//============================================
//Library Section
extends Modelica.Constants ;
 
//============================================
//Variable Section
Real A(unit = "m^2") "Cross sectional area of pipe" ;
Real q(unit = "m^3/s") "Volumetric flow rate of steam" ;
Real v(unit = "m/s") "Velocity of steam" ;
 
//============================================ 
//Equation Section
equation
A = pi/4*((d+0.068)*2.54*10^(-2))^2 ; 
   //Note: Using conversion factors from Table 1.3, pg 9
   //3" NB 40 Sc is 3.068 inch
q = m*0.46166/3600 ;   
v = q/A ; 
   //At Steam pressure (p) and temperature (T) specific volume from steam table is 0.46166 m3/kg:Ref steam tables, Appendix IV
    
end Ex1_2;
//============================================