//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-1: Dimensions and Units
//Example: 1.4 Page 13
//Title: Equation conversion to SI units

//==============================================
model Ex1_4

//==============================================
//Parameter Section
parameter Real k1 = 89.2 "Constant" ;
parameter Real C1(unit = "ft^3/s") = 1 "Conductance " ;
parameter Real A1(unit = "ft^2") = 1 "Area of orifice opening" ;
parameter Real T1(unit = "degree R") = 1 "Temperature" ;

//==============================================
//Variable Section
 Real C2(unit = "m^3/s") "Conductance" ;
 Real A2(unit = "m^2") "Area of orifice opening" ;
 Real T2(unit = "K") "Temperature" ;
 Real k2 "Constant" ;
 
//============================================== 
//Equation section
equation
 C2 = C1*35.31467 ;
 A2 = A1*10.76391 ;
 T2 = 1.8*T1 ; 
 k2 = k1*A2*(T2)^(0.5)/C2   "C=89.2*A(T/M)^(0.5)";

 //Using conversion factors from table 1.3, pg 9
 //C2=36.4489*A2(T2/M)^(0.5) 
 
end Ex1_4;