//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.21 Page 29
//Title: pH calculation of HOCl
//===============================================
model Ex2_21

//===============================================
//Parameter Section
parameter Real Ma(unit = "mol/L") = 0.1 "Molarity of HOCl" ;
parameter Real Ka = 9.6E-7 "Ionisation constant of HOCl" ;

//===============================================
//Variable Section
Real Conc "Concentration of H+ ions" ;
Real pH "pH of HOCl" ;

//===============================================
//Equation Section
equation
Conc = (Ma*Ka)^(0.5) ;
pH = -log10(Conc) ;

end Ex2_21;
//===============================================