//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.28 Page 44
//Title: Absolute humidity
//======================================================= 
model Ex2_28

//=======================================================
//Parameter Section
parameter Real P(unit = "kPa") = 100 "Total Pressure" ;
parameter Real Pw(unit = "kPa") = 2.5326 "Vapor pressure of water at its dew point(294.45 K)" ;

//=======================================================
//Variable Section
Real H (unit = "kg water vapor/kg dry air") "Absolute humidity of air" ;

//=======================================================
//Equation Section
equation
H = Pw/(P-Pw)*18.0153/28.9697 ;
//Molar mass of water is 18.0153
//Molar mass of air is 28.9697
//Absolute humidity in kg water vapor/kg dry air

end Ex2_28;
//=======================================================