//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.2 Page 61
//Title: Double effect evaporator
//=======================================================
model Ex3_2

//=======================================================
//Parameter Section
parameter Real feed(unit = "kg") = 100 "Basis for weak liquor feed" ;
parameter Real m1(unit = "kg") =4 "Mass of Caustic soda in feed" ;
parameter Real mp = 0.25 "Mass percent of Caustic soda in lye" ;

//=======================================================
//Variable Section
Real x(unit = "kg") "Mass of Caustic soda in lye" ;
Real evaporation(unit = "kg") "Mass of water evaporated" ;

//=======================================================
//Equation Section
equation
4 = mp*x ;//Component balance
evaporation = feed-x ;

end Ex3_2;
//=======================================================