//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.5 Page 62
//Title: Extraction of mixture of Acetone and Chloroform
//=======================================================
package Ex3_5

//=======================================================
model Ex3_5_a
/* Quantities of two layers */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Basis for original feed" ;
parameter Real m1(unit = "kg") = 27.8 "Mass of Acetone (A) in feed" ;
parameter Real m2(unit = "kg") = 72.2 "Mass of Chloroform (B) in feed" ;
parameter Real A1 = 7.5 "Mass percent of A in upper layer " ;
parameter Real A2 = 20.3 "Mass percent of A in lower layer" ;
parameter Real B1 = 3.5 "Mass percent of B in upper layer" ;
parameter Real B2 = 67.3 "Mass percent of B in lower layer" ;
parameter Real S11 = 57.4 "Mass percent of Water in upper layer" ;
parameter Real S12 = 2.8 "Mass percent of water in lower layer" ;
parameter Real S21 = 31.6 "Mass percent of Acetic acid in upper layer" ;
parameter Real S22 = 9.6 "Mass percent of Acetic acis in lower layer" ;

//=======================================================
//Variable Section
Real x(unit = "kg") "Mass of upper layer" ;
Real y(unit = "kg") "Mass of lower layer" ;
Real Mt(unit = "kg") "Total mass of mixed solvent" ;

//=======================================================
//Equation Section
equation
(A1*x+A2*y)/100 = m1 ;
(B1*x+B2*y)/100 = m2 ;
Mt = x+y-m ;

end Ex3_5_a ;
//=======================================================

//=======================================================
model Ex3_5_b
/* Mass ratio of mixed solvetn to original mixture */

//=======================================================
extends Ex3_5_a;

//=======================================================
//Variable Section
Real Mr "Mass ratio of mixed solvetn to original mixture" ;

//=======================================================
//Equation Section
equation
Mr = Mt/m ;

end Ex3_5_b ;
//=======================================================

//=======================================================
model Ex3_5_c
/* Composition of mixed solvent */

//=======================================================
extends Ex3_5_a ;
//=======================================================
//Variable Section
Real S1(unit = "kg") "Mass of Water in mixed solvent" ;
Real S2(unit = "kg") "Mass of Acetic acid in mixed solvent" ;
Real sp1 "Percent of water in mixed solvent" ;
Real sp2 "Percent of Acetic acid in mixed solvent" ;

//=======================================================
//Equation Section
equation
S1 = S11/100*x+S12/100*y ;
S2 = S21/100*x+S22/100*y ;
sp1 = S1/(S1+S2)*100 ;
sp2 = S2/(S1+S2) *100 ;

end Ex3_5_c ;
//=======================================================

end Ex3_5;
//=======================================================
