//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.11 Page 132
//Title: Pyrite fines roasting

//=======================================================
package Ex4_11

//=======================================================
model Ex4_11_a
/* % of S in cinder */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Basis for pyrites" ;
parameter Real S(unit = "kg") = 42 "S in pyrites" ;
parameter Real I(unit = "kg") = 58 "Inerts in pyrites" ;
parameter Real S1 = 2.3 "Percent of S as SO3 in cinder" ;

//=======================================================
//Variable Section
Real m1(unit = "kg") "O2 forming Fe2O3" ;
Real m2(unit = "kg") "Mass of SO3 free cinder" ;
Real m3(unit = "kg") "SO3-free cinder" ;
Real m4(unit = "kg") "Actual amount of cinder" ;
Real S2(unit = "kg") "S in cinder" ;
Real Percent "Percentage of S in cinder on basis of original charge" ;

//=======================================================
//Equation Section
equation
m1 = (3*32)/(8*32)*S ;
m2 = I+m1 ;
m3 = 100-(2.3/32*80) ;
m4 = 100/m3*m2 ;
S2 = m4*S1/100 ;
Percent = S2/S*100 ;
 
//8 mol of S is equivalent to 3 mol of O2 in Fe2O3
//100 kg of cinder contains 2.3 kg of S
//S1 is divided by 100 to convert  mass percent to mass fraction

end Ex4_11_a ;
//=======================================================

//=======================================================
model Ex4_11_b 
/* Percent of burnt S leaving roaster as SO3 */

//=======================================================
//Parameter Section
parameter Real m(unit = "kmol") = 100 "Basis of SO3-free roaster gases" ;
parameter Real m1(unit = "kmol") = 7.12 "SO2 in roaster gas" ;
parameter Real m2(unit = "kmol") = 10.6 "O2 in roaster gas" ;
parameter Real per3 = 4.29 "Percent of S as SO3 in cinder" ;

//=======================================================
//Variable Section
Real m3(unit = "kmol") "N2 in roaster gas" ;
Real m4(unit = "kmol") "O2 entering roaster" ;
Real m5(unit = "kmol") "O2 accounted" ;
Real m6(unit = "kmol") "O2 unaccounted" ;
Real m7(unit = "kmol") "SO3 formed" ;
Real m8(unit = "kmol") "Total S burnt" ;
Real per1 "Percent of S burnt to SO3" ;
Real per2 "Percent of S as SO3 in roaster gas" ;

//=======================================================
//Equation Section
equation
m3 = m-(m1+m2) ;            //SO3-free basis
m4 = (21/79)*m3 ;
m5 = 7.12+m2+(3/8*7.12) ;
m6 = m4-m5 ;
m7 = (8/15)*m6 ;            //8 kmol of SO3 are formed for 15 kmol of O2
m8 = m1+m7 ;
per1 = m7/m8*100 ;
per2 = per1-per3 ;

//O2 in SO2 = SO2 in roaster gas

end Ex4_11_b ;
//=======================================================

//=======================================================
model Ex4_11_c
/* Volumetric flow rate of air */

//=======================================================
//Parameter Section 
parameter Real S1(unit = "kg") = 37.81 "S roasted to SO2" ;
parameter Real T(unit = "K") = 300.15 "Temperature of air supplied for roasting" ;
parameter Real P(unit = "kPa") = 100 "Pressure of air" ;
parameter Real m(unit = "kg") = 100 "Basis for feed pyrites" ;

//=======================================================
//Variable Section
Real m1(unit = "kmol") "SO2 formed" ;
Real m2(unit = "kmol") "Air supplied for 7.12 kmol of SO2" ;
Real m3(unit = "kmol") "Air supplied for m1 kmol of SO2" ;
Real m4(unit = "kmol/s") "Total air supplied" ;
Real sp_vol(unit = "m^3/kmol") "Specific volume of entering air" ;
Real Q(unit = "m^3/s") "Volumetric flow rate of air" ;

//=======================================================
//Equation Section
equation
m1 = S1/32 ;
m2 = 82.28+21.88 ;                       //Air = N2+O2
m3 = (m2/7.12)*m1 ;
m4 = m3*4/100 ;
sp_vol = 22.414*(101.325/P)*(T/273.15) ;
Q = sp_vol*m4 ;
 
end Ex4_11_c ;
//=======================================================

//=======================================================
model Ex4_11_d
/* Volumetric flow rate of roaster gases */

//=======================================================
//Parameter Section
parameter Real m(unit = "kmol") = 100.455 "Total roaster gas for 104.16 kmol of air supply" ;
parameter Real a(unit = "kmol/s") = 0.6912 "Total air supplied" ;
parameter Real T(unit = "K") = 798.15 "Temperature of roaster gas" ;
parameter Real P(unit = "kPa") = 100 "Pressure of roaster gas" ;

//=======================================================
//Varaible Section
Real m1(unit = "kmol") "Roaster gases" ;
Real sp_vol(unit = "m^3/kmol") "Specific volume of roaster gases" ;
Real Q(unit = "m^3/s") "Volumetric flow rate of roaster gases" ;

//=======================================================
//Equation section
equation
m1 = m*a/104.16 ;
sp_vol = 22.414*(101.325/P)*(T/273.15) ;
Q = m1*sp_vol ;

end Ex4_11_d ;
//=======================================================

//=======================================================
model Ex4_11_e
/* Analysis of gas leaving SO3 converter */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100.455 "Total roaster gases" ;
parameter Real Conv = 96 "Percent conversion of SO2 to SO3" ;

//=======================================================
//Variable Section
Real m1(unit = "kmol/s") "SO2 entering converter" ;
Real m2(unit = "kmol/s") "SO2 converted" ;
Real m3(unit = "kmol/s") "SO2 unconverted" ;
Real m4(unit = "kmol/s") "O2 consumed" ;
Real m5(unit = "kmol/s") "O2 entering converter" ;
Real m6(unit = "kmol/s") "O2 unreacted" ;
Real m7(unit = "kmol/s") "SO3 formed" ;
Real m8(unit = "kmol/s") "SO3 entering converter" ;
Real m9(unit = "kmol/s") "SO3 leaving converter" ;
Real m10(unit = "kmol/s") "N2 in gases" ;

//=======================================================
//Equation Section
equation
m1 = 7.12*0.6666/m ;
m2 = m1*Conv/100 ;
m3 = m1-m2 ;
m4 = m2/2 ;
m5 = 0.6666*10.6/m ;
m6 = m5-m4 ;
m7 = m2 ;
m8 = 0.455/m*0.6666 ;
m9 = m7+m8 ;
m10 = 82.28/m*0.6666 ;

end Ex4_11_e ;
//=======================================================

//=======================================================
model Ex4_11_f
/* Amount of H2SO4 produced */

//=======================================================
//Reference Section 
extends Ex4_11_e ;

//=======================================================
//Variable Section 
Real N1(unit = "kmol/s") "SO3 absorbed in absorber" ;
Real N(unit = "ton/day") "Amount of 98% acid strength" ;

//=======================================================
//Equation Section
equation
N1 = m9*0.98 ;
N = N1*98*24*3600/0.98/1000 ;

end Ex4_11_f ;
//=======================================================

end Ex4_11;
//=======================================================
