//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.15 Page 143
//Title: Electrochemical cell 

//=======================================================
package Ex4_15

//=======================================================
model Ex4_15_a
/* amount of copper liberated */

//=======================================================
//Parameter Section
parameter Real V(unit = "m^3") = 1.12 "Basis of O2 at NTP" ;
parameter Real sp_vol(unit = "m^3/kmol") = 22.4 "Specific volume of O2 at NTP" ;

//=======================================================
//Variable Section
Real m1(unit = "g") "Equivalent mass of O2" ;
Real m2(unit = "g") "O2 libeared" ;
Real m3(unit = "g") "Equivalent mass of Cu" ;
Real m4(unit = "g") "Cu deposited" ;

//=======================================================
//Equation Section 
equation
m2 = V*1000*32/sp_vol ;
m1 = m2/(16/2) ;
m3 = 63.5/2 ;
m4 = m3*m1 ;

//1 mol of O2 = 2 mol of CuSO4

end Ex4_15_a ;
//=======================================================

//=======================================================
model Ex4_15_b
/*Current efficiency of cell */

//=======================================================
//Variable Section
Real E(unit = "faraday") "Total energy passed through the soln in cell" ;
Real m5(unit = "g") "Theoretical Cu liberation" ;
Real I "Current efficiency" ;

//=======================================================
//Reference Section
extends Ex4_15_a ;

//=======================================================
//Equation Section
equation
E = 1130*18000/96485 ;
m5 = E*m3 ;
I = m4/m5*100 ;

end Ex4_15_b ;
//=======================================================

end Ex4_15;
//=======================================================
