//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.7 Page 123
//Title: Saponification of tallow

//=======================================================
package Ex4_7

//=======================================================
model Ex4_7_a
/* Theoretical requirement of NaOH */

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 100 "Mass of tallow" ;

//=======================================================
//Variable Section
Real m2(unit = "kg") "NaOH required" ;

//=======================================================
//Equation Scetion
equation
m2 = 3*40*m1/890 ;
//Note: 1 kmol of tallow reacts with 3 kmol of NaOH
//Molar mass of tallow is 890 kg/kmol 
//Molar mass of NaOH is 40 kg/kmol

end Ex4_7_a ;
//=======================================================

//=======================================================
model Ex4_7_b
/* Glycerine liberated */

//=======================================================
//Variable Section
Real m3(unit = "mg/L") "Lime required" ;

//=======================================================
//Reference Section
extends Ex4_7_a ;

//=======================================================
//Equation Section
equation
m3 = 92/890*m1 ;
//Molar mass of glycerine is 92 kg/kmol

end Ex4_7_b ;
//=======================================================

end Ex4_7;
//=======================================================
