//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.10 Page 225
//Title: Latent heat of vapourisation 

//=======================================================
package Ex5_10

//=======================================================
model Ex5_10_a
/* Using Reidel Equation */

//=======================================================
//Parameter Section
parameter Real Pc(unit = "kPa") = 3732 "Critical pressure" ;
parameter Real Tc(unit = "K") = 630.3 "Critical temperature" ;
parameter Real Tb(unit = "K") = 417.6 "Boiling point of o-xylene" ;

//=======================================================
//Variable Section 
Real Tbr(unit = "K") "Reduced temperature" ;
Real Lambda(unit = "kJ/kmol") "Latent heat of vapourisation of o-xylene at Tb" ;

//=======================================================
//Equation Section
equation
Tbr = Tb/Tc ;
Lambda = 8.314472*Tb*1.092*(log(Pc)-5.6182)/(0.930-Tbr) ;

//Note: Ref. Table 5.5

end Ex5_10_a ;
//=======================================================

//=======================================================
model Ex5_10_b 
/* Using Watson equation */

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 298.15 "Temperature" ;
parameter Real Tc(unit = "K") = 630.3 "Critical temperature" ;
parameter Real Tb(unit = "K") = 417.6 "Boiling point of o-xylene" ;

//=======================================================
//Variable Section
Real Lambda(unit = "kJ/kmol") "Latent heat of vapourisation of o-xylene at T" ;

//=======================================================
//Equation Section
equation
Lambda = 36240*((Tc-T)/(Tc-Tb))^(0.38) ; 

end Ex5_10_b ;
//=======================================================

end Ex5_10;
//=======================================================
