//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.12 Page 227
//Title: Saturation pressure of steam

//=======================================================
model Ex5_12

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 565.15 "Temperature" ;
parameter Real T1(unit = "K") = 563.65 "Temperature" ;
parameter Real Ps1(unit = "bar") = 75 "Saturation pressure at T1" ;
parameter Real T2(unit = "K") = 568.12 "Temperature" ;
parameter Real Ps2(unit = "bar") = 80 "Saturation pressure at T2" ;

//=======================================================
//Variable Section
Real Ps(unit = "bar") "Saturation pressure at T";

//=======================================================
//Equation Section
equation
log(Ps/Ps1) = T2*(T-T1)/T/(T2-T1)*log(Ps2/Ps1) ;

end Ex5_12;
//=======================================================