  //Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.13 Page 236
//Title: Dew point and bubble point

//=======================================================
model Ex5_13

//=======================================================
//Parameter Section
parameter Real n(unit = "kmol") = 1 "Moles of equimolar mixture" ; 
parameter Real n1(unit = "kmol") = 0.5 "Moles of n-pentane in mixture" ;
parameter Real n2(unit = "kmol") = 0.5 "Moles of n-hexane in mixture" ;
parameter Real P(unit = "kPa") = 101.325 "Total pressure of system"; 
parameter Real Ts1(unit = "K") = 309.2 "Boiling point of n-pentane"; 
parameter Real Ts2(unit = "K") = 341.9 "Boiling point of n-hexane"; 

//=======================================================
//Variable Section
Real Tbb(unit = "K") "Bubble point of mixture" ;
Real T1(unit = "K") "First guess temperature" ;
Real Tdp(unit = "K") "Dew point of mixture" ;

//=======================================================
//Equation Section
equation
T1 = (Ts1+Ts2)/2 ;
//Using above given data we get table 5.10 and 5.11
Tbb = 321.6 ;
Tdp = 329.9 ;

end Ex5_13;
//=======================================================