//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.17 Page 242
//Title: Melting of tin in open pan

//=======================================================
model Ex5_17

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of tin as basis" ;
parameter Real T1(unit = "K") = 303.15 "Initial temperature of tin" ;
parameter Real T2(unit = "K") = 505.15 "Melting point of tin" ;
parameter Real lambdav(unit = "kJ/kg") = 278 "Latent heat of vapourisation of eutectic mixture" ;
parameter Real lambdaf(unit = "kJ/kg") = 7201 "Latent heat of fusion of tin" ;

//=======================================================
//Variable Section
Real n(unit = "kmol") "Moles of tin" ;
Real Q1(unit = "kJ") "Sensible heat" ;
Real Q2(unit = "kJ") "Latent heat" ;
Real Q(unit = "kJ") "Total heat supplied" ;
Real m1(unit = "kg") "Amount of vapour condensed" ;

//=======================================================
//Equation Section
equation
n = m/118.7 ;
Q1 = n*(21.14*(T2-T1)+0.02*(T2^2-T1^2)/2) ;
Q2 = n*lambdaf ;
Q = Q1+Q2 ;
m1 = Q/lambdav ;

end Ex5_17;
//=======================================================