//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.19 Page 245
//Title: Manufacture of dry ice

//=======================================================
package Ex5_19

//=======================================================
model Ex5_19_a
/* Yield of dry ice */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg/hr") = 100 "Basis for feed gas" ;
parameter Real E1(unit = "kJ/kg") = 482.9 "Enthalpy of CO2 at 20 MPa and 403 K" ;
parameter Real E2(unit = "kJ/kg") = 273.4 "Enthalpy of CO2 at 20 MPa and 313 K" ;
parameter Real T1(unit = "K")  = 313.15 "Initial temperature of CO2" ;
parameter Real T2(unit = "K")  = 403.15 "Final temperature of CO2" ;
parameter Real H1(unit = "kJ/kg") = 427.8 "Enthalpy of CO2 vapour at 20 MPa" ;
parameter Real h1(unit = "kJ/kg") = 211.1 "Enthalpy of CO2 liq. at 20 MPa" ;
parameter Real Ts(unit = "K") = 277.6 "Saturation temperature of CO2 at 20 MPa" ;
parameter Real h2(unit = "kJ/kg") = -148.39 "Enthalpy of dry ice vapour at 194.69 K" ;
parameter Real H2(unit = "kJ/kg") = 422.61 "Enthalpy of CO2 vapour at 194.69 K" ;
parameter Real h3(unit = "kJ/kg") = 176.18 "Enthalpy of CO2 liq at 3.9 MPa" ;

//=======================================================
//Variable Section
Real Q1(unit = "kJ/hr") "Heat removed in water cooler"; 
Real Q11(unit = "kJ/hr") "Heat removed from CO2" ;
Real x(unit = "kg") "CO2 liquefied" ;
Real Q2(unit = "kJ/hr") "Heat duty of condenser" ;
Real y(unit = "kg") "Mass of CO2 liq. converted to dry ice at aym pressure" ;

//=======================================================
//Equation Section
equation
Q1 = m*(E1-E2) ;
Q11 = (21.3655*(T2-T1)+64.2841*10^(-3)*(T2^2-T1^2)/2-41.0506*10^(-6)*(T2^3-T1^3)/3+9.7999*10^(-9)*(T2^4-T1^4)/4) ;
x*h1+(m-x)*H1 = m*E2 ;
Q2 = (m-x)*(H1-h1) ;
h3*m = (m-y)*H2+h2*y ;

end Ex5_19_a ;
//=======================================================

//=======================================================
model Ex5_19_b
/* Percent liquefaction */

//=======================================================
//Reference Section
extends Ex5_19_a ;

//=======================================================
//Variable Section
Real P "Pecentage of CO2 liquefied" ;

//=======================================================
//Equation Section
equation
P = x/m*100 ;

end Ex5_19_b ;
//=======================================================

//=======================================================
model Ex5_19_c
/* Temperature of gas vented */

//=======================================================
//Referamce Section
extends Ex5_19_a ;

//=======================================================
//Variable Section
Real q(unit = "kJ/hr") "Heat carried out by CO2 vapor at 194.69 K" ;
Real Q3(unit = "kJ/hr") "Heat transfer in revert gas exchanger" ;
Real H(unit = "kJ/hr") "Enthalpy of CO2 gas from revert heat exchanger" ;
Real H4(unit = "kJ/kg") "Specific enthalpy pf CO2 from revert gas exchanger" ;

//=======================================================
//Equation Section
equation
q = (m-y)*H2 ;
Q3 = m*(h1-h3) ;
H = q+Q3 ;
H4 = H/(m-y) ;

end Ex5_19_c ;
//=======================================================

end Ex5_19;
//=======================================================