//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.28 Page 261
//Title: Standard heat of formation of diethyl ether

//=======================================================
model Ex5_28

//=======================================================
//Parameter Section
parameter Real lambda(unit = "kJ/kmol") = 26694 "Latent heat of vapourisation at 307.7 K" ;
parameter Real Tc(unit = "K") = 466.74 "Critical temperature" ;
parameter Real Hf0_g(unit = "kJ/mol") = -252 "Standard heat of formation of diethyl ether gas" ;

//=======================================================
//Variable Section
Real lambda1(unit = "kJ/mol")  "Latent heat of vapourisation at 298.15 K" ;
Real Hf0_l(unit = "kJ/mol") "Standard heat of formation of diethyl ether liquid" ;

//=======================================================
//Equation Section
equation
lambda1 = lambda/1000*((Tc-298.15)/(Tc-307.7))^(0.38) ;
Hf0_l = Hf0_g-lambda1 ;

//Note: Ref. Appendix V.2

end Ex5_28;
//=======================================================