//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.3 Page 198
//Title: Heat added to CH4

//=======================================================
model Ex5_3

//=======================================================
//Parameter Section
Real T1(unit = "K") = 303.15 "Initial Temperature" ;
Real T2(unit = "K") = 523.15 "Final Temperature" ;
Real Tc(unit = "K") = 190.5 "Critical temperature at 25 bar a" ;
Real Pc(unit = "bar") = 46.04 "Critical temperature at 25 bar a" ;

//=======================================================
//Variable Section
Real H(unit = "kJ") "Heat supplied per kmole of CH4" ;
Real Pr(unit = "bar") "Reduced pressure" ;
Real delta_T(unit = "K") "Temperature interval" ;
Real HE(unit = "kJ")   ;
//=======================================================
//Equation Section 
equation
Pr = 25/Pc ;
delta_T = (T2-T1)/4 ;
//Integration applying simpson's one-third rule
HE = delta_T/3*(2.6+4*(1.5+0.7)+2*1+0.52) ;
H = 9175.1+HE ;

end Ex5_3;
//=======================================================