//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.42 Page 297
//Title: Heat of crystallisation of Na2CO3.10 H2O

//=======================================================
model Ex5_42

//=======================================================
//Parameter Section
parameter Real T(unit = "K") =291.15 "Na2CO3.10 H2O dissolution temperature" ;
parameter Real H1(unit = "kJ/mol") = 62.86 "Heat of soln" ;
parameter Real M(unit = "kg/kmol") = 286.1414 "Molar mass of Na2CO3.10 H2O" ;
 
//=======================================================
//Variable Section
Real H2(unit = "kJ/kg") "Heat of crystallisation" ;

//=======================================================
//Equation Section
equation
H2 = H1*1000/M ;

end Ex5_42;
//=======================================================