//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.47 Page 300
//Title: Std. heat of formation

//=======================================================
model Ex5_47

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 100 "Mass of solution";
parameter Real m3(unit = "kg") = 46 "Mass of NaOH in solution" ;
parameter Real Hf1(unit = "kJ/mol") = -453.138 "Heat of formation of NaOH,2.6063 H2O" ;
parameter Real Hf2(unit = "kJ/mol") = -467.678 "Heat of formation of NaOH,6.6608 H2O" ;
parameter Real H1(unit = "kJ/kg") = 146.65 "Enthalpy of water at 308.15 K" ;
parameter Real H2(unit = "kJ/kg") = 104.9 "Enthalpy of water at 298.15 K" ;

//=======================================================
//Variable Section
Real n1(unit = "kmol") "Moles of NaOH in solution" ;
Real n2(unit = "kmol") "Moles of H2O in solution" ;
Real m2(unit = "kg") "Mass of final solution" ;
Real Hsol(unit = "kJ/mol") "Heat of solution" ;
Real Q(unit = "kJ") "Heat generated" ;
Real Q1(unit = "kJ") "Heat added to water" ;
Real H(unit = "kJ") "Total heat for raising temperature" ;
Real t2(unit = "degree C") "Final temperature of soln" ;

//=======================================================
//Equattion Section
equation
n1 = m3/40 ;
n2 = (m1-m3)/18 ;
m2 = m3/0.25 ;                                   //Final conc. 25% NaOH
Hsol = Hf2-Hf1 ;
Q = -Hsol*1000*n1 ;
Q1 = 84*(H1-H2) ;
H =Q+Q1 ;
t2 = 25+H/(m2*3.55) ;

//Enthalpy of water, Ref. Steam table Appendix IV.1
//Average heat capacity C1 = 3.55 kJ/(kg.K) Ref. Fig 5.4
end Ex5_47;
//=======================================================
