//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.48 Page 301
//Title: Heat effect of solution

//=======================================================
model Ex5_48

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of solution" ;
parameter Real m1(unit = "kg") = 32 "Mass of N in solution" ;
parameter Real M1(unit = "kg/kmol") = 80.0434 "Molar mass of NH4NO3" ;
parameter Real M2(unit = "kg") = 60.0553 "Molar mass of NH2CONH2" ;
parameter Real M3(unit = "kg") = 28.0134 "Molar mass of N2" ;

//=======================================================
//Variable Section
Real na(unit = "kmol") "Moles of NH4NO3 dissolved" ;
Real n1(unit = "kmol") "Moles of urea dissolved" ;
Real n2(unit = "kmol") "Moles of Nitrogen" ;
Real m2(unit = "kg") "Mass Urea dissolved" ;
Real m3(unit = "kg") "Mass water" ;
Real molality(unit = "mol/kg") "Molality of solution" ;
Real H(unit = "kJ/mol") "Heat of dissolution" ;
Real HE(unit = "kJ") "Heat of solution" ;

//=======================================================
//Equation Section
equation
n1 = 1.1758*na ;
n2 = na+1.1758*na ;
n2*M3 = m1 ;
m2 = n1*M2 ;
m3 = m-(na*M1+m2) ;
molality = na*1000/m3 ;
H = 40.3044-2.5962*(molality)+0.1582*(molality)^2-3.4782*10^(-3)*(molality)^3 ;
HE = H*na*1000 ;

end Ex5_48;
//=======================================================