//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.56 Page 312
//Title: Heat balance of absorber

//======================================================
model Ex5_56

//======================================================
//Parameter Section
parameter Real Hsol(unit = "kJ/mol") = 62.75 "Heat of solution" ;

//======================================================
//Variable Section
Real Q5(unit = "kJ/hr") "Enthalpy of gas mixture entering absorber" ;
Real Q6(unit = "kJ/hr") "Heat evolved by absorbtion" ;
Real Q7(unit = "kJ/hr") "Enthalpy of absorber exit gas stream" ;
Real Q8(unit = "kJ/hr") "Enthalpy of fresh water" ;
Real Q9(unit = "kJ/hr") "Enthalpy of HCHO solution" ;
Real Q10(unit = "kW") "Heat removal in cooler" ;

//======================================================
//Equation Section
equation
Q5 = 15505407-11395056 ;
Q6 = 111.375*Hsol*1000 ;
//Q7 = integrate Cmpab dT over 298.15 and 323.15
Q7 = 1063379  ;
Q8 = 5532.15*4.1868*(303.15-298.15) ;
Q9 = 9030.4*3.45*(323.15-298.15) ;
Q10 = (Q5+Q6+Q8-Q7-Q9)/3600 ;

//Ref Ex4_10 and Ex5_37

end Ex5_56;
//======================================================