//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.60 Page 320
//Title: Heat of dilution using partial molar enthalpy

//=======================================================
model Ex5_60

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of H2SO4 solution" ;
parameter Real m1(unit = "kg") = 78.4 "Mass of SO3 from Table 5.64" ; 
parameter Real m2(unit = "kg") = 21.6 "Mass of H2O from Table 5.64" ; 

//=======================================================
//Variable Section
Real n1(unit = "kmol") "Moles of SO3 in soln." ;
Real n2(unit = "kmol") "Moles of H2O in soln." ;
Real m3(unit = "kg") "Mass of resultant soln. after dilution" ;
Real m4(unit = "kg") "Mass of water added for dilution" ;
Real n3(unit = "kmol") "Moles of H2O in resultant soln." ;
Real He1(unit = "kJ") "Enthalpy of original solution" ;
Real He2(unit = "kJ") "Enthalpy of resultant solution at 291.15 K" ;
Real He3(unit = "kJ/kg") "Enthalpy of water per 100 kg of original soln. at 291.15 K" ;
Real delta_T(unit = "K") "Rise in temperature" ;
Real T(unit = "K") "Final temperature" ;

//=======================================================
//Equation Section
equation
n1 = m1/80.063 ;
n2 = m2/18.015 ;   
//Resultant solution is 23.2% H2SO4 i.e. 100 kg of 23.2% H2SO4 having 19% H2SO4
m3 = m1/0.19 ;
m4 = m3-m ;
n3 = (m3-m1)/18.015 ;
He1 = n1*(-56940)+n2*(-32657) ;
He2 = n1*(-156168)+n3*(-335) ;
He3 = (He2-He1) ;
delta_T = -He3/(m3*3.43) ;
T = 291.15+delta_T ;

end Ex5_60;
//=======================================================