//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.1 Page 346
//Title: Rectification of benzene toluene mixture

//======================================================
model Ex6_1

//======================================================
//Parameter Section
parameter Real F(unit = "kmol") = 100 "Moles of feed" ;
parameter Real n1(unit = "kmol") = 72 "Moles of C6H6 in feed" ;
parameter Real n2(unit = "kmol") = 28 "Moles of toluene in feed" ;
parameter Real xD = 0.995 "Mole fraction of MVC in distillate" ;
parameter Real xB = 0.03 "Mole fraction of MVC in Bottom" ;
parameter Real R = 1.95 "Reflux ratio" ;

//======================================================
//Variable Section
Real D(unit = "kmol") "Distillate" ;
Real B(unit = "kmol") "Bottom product" ;
Real V(unit = "kmol") "Overhead vapours" ;
Real H1(unit = "kJ/kmol") "Enthalpy of overhead vapours" ;
Real H2(unit = "kJ/kmol") "Enthalpy of overhead liquid" ;
Real Q1(unit = "kJ/kmol") "Enthalpy removed in condenser" ;
Real Hc(unit = "kJ") "Heat load of condenser" ;
Real Hd(unit = "kJ") "Enthalpy of distillate" ;
Real Hb(unit = "kJ") "Enthalpy of bottom" ;
Real Hf(unit = "kJ") "Enthalpy of feed" ;
Real Hn(unit = "kJ") "Heat load of reboiler" ;

//======================================================
//Equation Section
equation
//Overall balance
F = D+B ;
//Benzene balance
xD*D+xB*B = n1 ;
V = D*(1+R) ;
H1 = 42170 ;
H2 = 11370 ;
Q1 = H1-H2 ;
Hc = Q1*V ;
Hd = H2*D ;
Hb = 18780*B ;
Hf = 44500*F ;
Hn = Hd+Hc+Hb-Hf ;

//Ref. Fig 6.2, Benzene-Toluene Enthalpy diagram

end Ex6_1;
//======================================================