//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.10 Page 368
//Title: Cooling in crystalliser

//======================================================
model Ex6_10

//======================================================
//Parameter Section
parameter Real F(unit = "kg") = 100 "Free water in original solution" ;
parameter Real e(unit = "kg") = 4 "Percent of origisl solution evaporated" ;

//======================================================
//Variable Section
Real H2O_sol1(unit = "kg") "Associated water in original solution" ;
Real H2O_free1(unit = "kg") "Free water in original solution" ;
Real mg1(unit = "kg") "Mgso4.7H2O in 100 kg of water" ;
Real evap(unit = "kg") "Evaporation" ;
Real H2O_free2(unit = "kg") "Free wate in mother liquor" ;
Real H2O_mg1(unit = "kg") "Water asssociated with MgSO4" ;
Real mg2(unit = "kg") "Crystals of MgSO4.7H2O" ;
Real M(unit = "kg") "Origunal quantity if solution fed " ;
Real yield "Yield of crystals" ;
Real charge(unit = "kg") "For yield of 1000 kg of crystals charge is" ;
Real H2O_free3(unit = "kg") "Free wate in mother liquor" ;

//======================================================
//Equation Section
equation
H2O_sol1 = 126/120.3*64.2 ;
H2O_free1 = F-H2O_sol1 ;
mg1 = (64.2+H2O_sol1)/32.76*F ;
evap = (mg1+F)*e/100 ;
H2O_free2 = F-evap ;
H2O_mg1 = (126/120.3)*40.8 ;
H2O_free3 = F-H2O_mg1 ;
mg2 = (H2O_mg1+40.8)*H2O_free2/ H2O_free3 ;
M = 501.2*F/yield ;
yield = mg1-mg2 ;
charge = 501.2*1000/yield ;

end Ex6_10;
//======================================================
