//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.19 Page 391
//Title: Hooker type diaphragm cell

//======================================================
model Ex6_19

//======================================================
//Parameter Section
parameter Real F(unit = "kg/hr") = 4000 "NaOH produced" ;
parameter Real P(unit = "kPa") = 101.325 "Total pressure" ;
parameter Real Pw(unit = "kPa") = 2.0624 "partial pressure of water at 291.15 K" ;

//======================================================
//Variable Section
Real Cl2(unit = "kg/hr") "Cl2 produced" ;
Real m1(unit = "kmol/hr") "Molar flow rate of Cl2" ;
Real H1 "Moisture in Cl2" ;
Real m3(unit = "kg/hr") "Total water vapour in saturated Cl2" ;
Real Q1(unit = "kJ/kg") "Heat of dilution" ;
Real n "kmol of H2O/kmol of H2SO4" ;
Real Q_sp(unit = "kJ/kg") "Total specific heat" ;
Real Q(unit = "kJ/kmol") "Total heat liberated" ;

//======================================================
//Equation Section
equation
Cl2 = (71/(80))*F ;                  //2 kmol of NaOH = 1 kmol of Cl2
m1 = Cl2/71 ;
H1 = Pw/(P-Pw)*18.0154/70.906 ;
m3 = Cl2*H1 ;
//Q = 74780*n/(n+1.7983) ;
//dQ/dn = Q1
Q1 = (134477/(n+1.7983)^2)/18.0153 ;
// For 90% conc
n = (10/18.0153)/(90/98.0776) ;
Q_sp = 2459+Q1 ;                     //Lambda = 2459 kJ/kg at 291.15 K Ref. Appx IV.!
Q = Q_sp*m3/3600 ;

end Ex6_19;
//======================================================