//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.2 Page 349
//Title: Cryogenic separation of N2

//======================================================
package Ex6_2

//======================================================
model Ex6_2_a
/* Composition of vapour-liquid */

//======================================================
//Parameter section
parameter Real m(unit = "kg/hr") = 2000 "Feed rate of liquid air" ;
parameter Real R = 3 "Reflux ratio" ;

//======================================================
//Variable Section
Real M(unit = "kg/kmol") "Av. molar mass of air" ;
Real F(unit = "kmol/hr") "Feed rate ";
Real D(unit = "kmol/hr") "Distillate flow rate ";
Real W(unit = "kmol/hr") "Bottoms flow rate ";
Real x "Mole fraction of N2 in flashed liquid" ;
Real y "Mole fraction of N2 in flashed vapour" ;

//======================================================
//Equation Section
equation
M = 0.79*28+0.21*32 ;
F = m/M ;
F = D+W ;
0.79*F = 0.999*D+0.422*W ;
//Trial I
/*x = 0.75 ;
y = 0.8833 ;
Hl = 1083.65 ;
Hv = 6050 ;
Hmix = 0.3*Hv+0.7*Hl ;
Hmix not equal to Hact*/
/*//Trail II
x = 0.735 ;
y = 0.9183 ;
Hl = 1085.6 ;
Hv = 6119.1 ;
Hmix = 0.3*Hv+0.7*Hl ;
Hmix not equal to Hact */
//Trail III
x = 0.71 ;
y = 0.859 ;

end Ex6_2_a ;
//======================================================

//======================================================
model Ex6_2_b 
/*Material and Energy balance */

//======================================================
//Parameter section
parameter Real m(unit = "kg/hr") = 2000 "Feed rate of liquid air" ;
parameter Real R = 3 "Reflux ratio" ;

//======================================================
//Variable Section
Real M(unit = "kg/kmol") "Av. molar mass of air" ;
Real F(unit = "kmol/hr") "Feed rate ";
Real D(unit = "kmol/hr") "Distillate flow rate ";
Real W(unit = "kmol/hr") "Bottoms flow rate ";
Real Hl(unit = "kJ/kmol") "Enthalpy of liquid" ;
Real Hv(unit = "kJ/kmol") "Enthalpy of vapour" ;
Real Hf(unit = "kJ/kmol") "Enthalpy of feed" ;
Real Qf(unit = "kW") "Total Enthalpy of feed" ;
Real V(unit = "kmol/hr") "Total overhead vapours" ;
Real Qv(unit = "KW") "Total enthalpy of overhead vapours" ;
Real Qc1(unit = "kJ/kmol") "Enthalpy removed in overhead condensers" ;
Real Qc(unit = "kW") "Heat duty of condenser" ;
Real Qc_act(unit = "kW") "Actual heat duty of condenser" ;
Real Qw(unit = "kJ/kmol") "Enthalpy of bottom" ;
Real Qb(unit = "kW") "Heat  load of reboiler" ;
Real Qb_act(unit = "kW") "Actual heat duty of reboiler" ;

//======================================================
//Equation Section
equation
M = 0.79*28+0.21*32 ;
F = m/M ;
F = D+W ;
0.79*F = 0.999*D+0.422*W ;
Hl = 1085.6 ;
Hv = 6118.6 ;
Hf = 0.3*Hv+0.7*Hl ;
Qf = F*Hf/3600 ;
V = D*(R+1) ;
Qv = 5852.3*V/3600 ;
Qc1 = 5852.3-1063.2 ;
Qc = Qc1*V/3600 ;
Qc_act = Qc/0.95 ;                      //5% heat loss to surrounding
Qw = 1113.8*W/3600 ;
Qb = 1063.2*D/3600+Qc+Qw-Qf ;
Qb_act = Qb*0.95 ;

end Ex6_2_b ;
//======================================================



end Ex6_2;
//======================================================
 
