//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.20 Page 394
//Title: Absorption of NH3 from purge gas

//======================================================
package Ex6_20

//======================================================
model Ex6_20_a
/* Temperature of feed water */

//======================================================
//Parameter Section
parameter Real F(unit = "kmol") = 100 "Feed gas" ;
parameter Real T1(unit = "K") = 263 "Temperature of feed gas in" ;
parameter Real T2(unit = "K") = 283 "Temperature of gas from heat exchanger" ;
parameter Real T3(unit = "K") = 307 "Temperature of water entering heat exchanger" ;

//======================================================
//Variable section
Real del_a "Heat capacity constants" ;
Real del_b "Heat capacity constants" ;
Real del_c "Heat capacity constants" ;
Real del_d "Heat capacity constants" ;
Real Q1(unit = "kJ") "Heat gained by mixture" ;
Real Q_NH3(unit = "kJ") "Heat gained by NH3" ;
Real m1(unit = "kmol") "NH3 free feed gas" ;
Real m2(unit = "kmol") "Outgoing gas mixture" ;
Real m3(unit = "kmol") "NH3 absorbed" ;
Real q(unit = "kg") "Flow rate 4% NH3 soln." ;
Real m4(unit = "kg") "Water content of soln." ;
Real del_T(unit = "K") "Fall in temperature" ;
Real T4(unit = "K") "Temperature of water leaving heat exchanger" ;

//======================================================
//Equation Section
equation
//Assuming heat capacities are constant
del_a = 2738.689 ;
del_b = 609.415*10^(-3) ;
del_c = 396.091*10^(-6) ;
del_d = -187.068*10^(-9) ;
Q1 = del_a*(T2-T1)+del_b*(T2^2-T1^2)/2+del_c*(T2^3-T1^3)/3+del_d*(T2^4-T1^4)/4 ;
Q_NH3 = 1533.8 ;
m1 = F-2.2 ;
m2 = m1/0.99995 ;
m3 = 2.2-0.005 ;
q = m3*17.03/0.04 ;
m4 = q-m3 ;
del_T = Q1/(m4*4.1868) ;
T4 = T3-del_T ;

end Ex6_20_a ;
//======================================================

//======================================================
model Ex6_20_b
/* Temperature of aq. NH3 leaving absorber */

//======================================================
//Parameter Section
parameter Real Hf1(unit = "kJ/mol") = -80.093 "Heat of formation of 4% NH3 solution" ;
parameter Real Hf2(unit = "kJ/mol") = -46.11 "Heat of formation of pure NH3" ;

//======================================================
//Reference Section
extends Ex6_20_a ;

//======================================================
//Variable section
Real H(unit = "kJ") "Heat evolved" ;
Real Q(unit = "kJ") "Heat picked by NH3 free gas mixture" ;
Real Q2(unit = "kJ") "Heat picked by NH3 soln." ;
Real del_T1(unit = "K") "Fall in temperature" ;
Real T5(unit = "K") "Temperature of NH3 leaving absorber" ;

//======================================================
//Equation Section
equation
H = (Hf1-Hf2)*m3 ;
Q = 2854.1*(291.4-283.15) ;
Q2 = 74593-Q ;
del_T1 = Q2/q/4.1868 ;
T5 = 291.4+del_T1 ;

end Ex6_20_b ;
//====================================================== 

end Ex6_20 ;
//======================================================
