//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.6 Page 361
//Title: Extraction of Acetic acid

//======================================================
model Ex6_6

//======================================================
//Parameter Section
parameter Real F(unit = "kg") = 100 "Mass of feed mixture as basis" ;
parameter Real xF = 0.475 "Mass fraction of acetic acid in feed" ;
parameter Real xE = 0.82 "Mass fraction of acetic acid in extract" ;
parameter Real xR = 0.14 "Mass fraction of acetic acid in raffinate" ;

//======================================================
//Variable Section
Real E(unit = "kg") "Mass of extract phase" ;
Real R(unit = "kg") "Mass of raffinate phase" ;
Real A_rem(unit = "kg") "Mass of acetic acid leftover in raffinate" ;
Real unext "Percentage of acetic acid unextracted" ;

//======================================================
//Equation Section
equation
//Overall material balance
F = E+R ;
//Balance of acetic acid
xF*F = xE*E+xR*R ;
A_rem = R*xR ;
unext = A_rem/(xF*F)*100 ;

end Ex6_6;
//======================================================
