//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.11 Page 473
//Title: Water tube boiler

//======================================================
model Ex7_11

//======================================================
//Parameter Section
parameter Real F(unit = "kg") = 100 "Mass of fuel oil as basis" ;
parameter Real m(unit = "kg/hr") = 400 "Fuel firing rate" ;

//======================================================
//Variable Section
Real CO2(unit = "kmol") "Moles of CO2 in flue gas" ;
Real N2(unit = "kmol") "N2 in dry flue gas" ;
Real O(unit = "kmol") "O2 in dry flue gas" ;
Real T(unit = "kmol") "Total dry flue gas" ;
Real O1(unit = "kmol") "Moles of O2 from air" ;
Real O2(unit = "kmol") "Moles of O2 entering burner" ;
Real O3(unit = "kmol") "Excess O2" ;
Real W1(unit = "kmol") "Moisture formed from combustion of H2" ;
Real H1 "Absolute humidity of air at 101.3 kPa" ;
Real H2 "corrected humidity" ;
Real W2(unit = "kmol") "Moisture from air" ;
Real W3(unit = "kmol") "Total moisture in flue gas" ;
Real H7(unit = "kJ") "Total heat lost in flue gas" ;
Real Q7(unit = "kJ/hr") "Heat lost in flue gas" ;
Real Q(unit = "kJ/kg") "Heat supplied in boiler" ;
Real Q5(unit = "kJ/hr") "Heat utilised in steam generation" ;
Real Q8(unit = "kJ/hr") "Heat lost due to evaporation of moisture" ;
Real Q1(unit = "kJ/hr") "Heat input by fuel combustion" ;
Real Fair(unit = "kg/hr") "Total dry flow rate of air" ;
Real Q3(unit = "kJ/hr") "Sensible heat of incoming air" ;
Real Q2(unit = "kJ/hr") "Sensible heat of fuel oil" ;
Real GCV "Overall efficiency based on GCV of fuel" ;
Real NCV(unit = "kJ/kg") "NCV of fuel" ;
Real NCV1 "Overall efficiency based on NCV of fuel" ;
Real qv(unit = "m^3/hr") "Volumetric flow rate" ;

//======================================================
//Equation Section
equation
//Material balance for C
 CO2 = 7.092+0.047 ;
 N2 = CO2*81.05/7.01 ;
 O = CO2*11.94/7.01 ;
 T = CO2+N2+O ;
//Material balance of O2
 O1 = (21/79)*N2 ;
 O2 = O1+0.078 ;
 O3 = O2-9.864 ;
//Material balance of water vapour
 W1 = 5.45 ;
 H1 = 0.0329 ;                                     //Fig. 6.15
 H2 = 0.0331 ;                                     //Ref. Table 6.14
 W2 = H2*(N2+O2) ;
 W3 = W1+W2 ;
//Using Table 7.32
H7 = 3391.203*(563.15-298.15) ;
Q7 = H7*m/F ;
Q = 2791.7-179.99 ;
Q5 = Q*4365 ;
Q8 = 5.45*18*(m/F)*2403.5 ;
Q1 = m*42260 ;                                    //GCV of fuel = 42260 kJ/kg
Fair = (N2+O1)*29*m/F ;
Q3 = Fair*1.0437*(308.15-298.15) ;
Q2 = m*1.758*(353.15-298.15) ;
GCV = Q5*100/Q1 ;
NCV = 42260-(18.0153/2.016)*0.109*2442.8 ;
NCV1 = Q5*100/(m*NCV) ;
qv = 110.743*(m/F)*8.3145*(563.15/99.3) ;

end Ex7_11;
//======================================================